<?php
require_once '../config/config.php';
require_once '../classes/Database.php';
require_once '../classes/Auth.php';

header('Content-Type: application/json; charset=utf-8');

$db = Database::getInstance();
$auth = new Auth($db);

if (!$auth->isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Not logged in']);
    exit;
}

$currentUser = $auth->getCurrentUser();
$action = $_GET['action'] ?? $_POST['action'] ?? '';

switch ($action) {
    // Send message to admin
    case 'send_message':
        $message = trim($_POST['message'] ?? '');
        
        if (empty($message)) {
            echo json_encode(['success' => false, 'message' => 'Message cannot be empty']);
            exit;
        }
        
        $result = $db->insert('admin_chats', [
            'user_id' => $currentUser['id'],
            'message' => $message,
            'sender_type' => 'user',
            'created_at' => date('Y-m-d H:i:s')
        ]);
        
        if ($result) {
            echo json_encode([
                'success' => true,
                'message' => 'Message sent',
                'chat_id' => $result,
                'timestamp' => date('Y-m-d H:i:s')
            ]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to send message']);
        }
        exit;
    
    // Get chat history
    case 'get_messages':
        $limit = (int)($_GET['limit'] ?? 50);
        $offset = (int)($_GET['offset'] ?? 0);
        
        $messages = $db->fetchAll(
            "SELECT id, message, sender_type, created_at, user_id 
             FROM admin_chats 
             WHERE user_id = ? 
             ORDER BY id DESC 
             LIMIT ? OFFSET ?",
            [$currentUser['id'], $limit, $offset]
        );
        
        // Reverse to show oldest first
        $messages = array_reverse($messages);
        
        echo json_encode([
            'success' => true,
            'messages' => $messages,
            'total' => count($messages)
        ]);
        exit;
    
    // Get unread count
    case 'get_unread_count':
        $result = $db->fetch(
            "SELECT COUNT(*) as count FROM admin_chats 
             WHERE user_id = ? AND sender_type = 'admin' AND is_read = 0",
            [$currentUser['id']]
        );
        
        echo json_encode([
            'success' => true,
            'unread_count' => $result['count'] ?? 0
        ]);
        exit;
    
    // Mark messages as read
    case 'mark_as_read':
        $db->query(
            "UPDATE admin_chats SET is_read = 1 
             WHERE user_id = ? AND sender_type = 'admin' AND is_read = 0",
            [$currentUser['id']]
        );
        
        echo json_encode(['success' => true]);
        exit;
    
    default:
        echo json_encode(['success' => false, 'message' => 'Unknown action']);
        exit;
}
?>
