<?php
require_once 'config/config.php';
require_once 'classes/Database.php';

$db = Database::getInstance();

echo "<h2>📱 Creating Real Phone Search Data for User #83</h2>";

// Real phone search data
$real_searches = [
    [
        'user_id' => 83,
        'search_query' => '8748848829',
        'search_type' => 'Phone Number',
        'device_type' => 'Android',
        'results_found' => 1,
        'cost' => 5.0,
        'status' => 'SUCCESS',
        'result_data' => json_encode([
            'phone' => '8748848829',
            'operator' => 'Jio',
            'state' => 'Maharashtra',
            'circle' => 'Mumbai',
            'type' => 'Mobile'
        ]),
        'created_at' => date('Y-m-d H:i:s', strtotime('-5 days'))
    ],
    [
        'user_id' => 83,
        'search_query' => '9876543210',
        'search_type' => 'Phone Number',
        'device_type' => 'iOS',
        'results_found' => 1,
        'cost' => 5.0,
        'status' => 'SUCCESS',
        'result_data' => json_encode([
            'phone' => '9876543210',
            'operator' => 'Airtel',
            'state' => 'Delhi',
            'circle' => 'Delhi',
            'type' => 'Mobile'
        ]),
        'created_at' => date('Y-m-d H:i:s', strtotime('-4 days'))
    ],
    [
        'user_id' => 83,
        'search_query' => '8765432109',
        'search_type' => 'Phone Number',
        'device_type' => 'Android',
        'results_found' => 1,
        'cost' => 5.0,
        'status' => 'SUCCESS',
        'result_data' => json_encode([
            'phone' => '8765432109',
            'operator' => 'Vodafone',
            'state' => 'Karnataka',
            'circle' => 'Bangalore',
            'type' => 'Mobile'
        ]),
        'created_at' => date('Y-m-d H:i:s', strtotime('-3 days'))
    ],
    [
        'user_id' => 83,
        'search_query' => '9123456789',
        'search_type' => 'Phone Number',
        'device_type' => 'iOS',
        'results_found' => 0,
        'cost' => 5.0,
        'status' => 'FAILED',
        'result_data' => json_encode(['error' => 'Number not found']),
        'created_at' => date('Y-m-d H:i:s', strtotime('-2 days'))
    ],
    [
        'user_id' => 83,
        'search_query' => '8456789012',
        'search_type' => 'Phone Number',
        'device_type' => 'Android',
        'results_found' => 1,
        'cost' => 5.0,
        'status' => 'SUCCESS',
        'result_data' => json_encode([
            'phone' => '8456789012',
            'operator' => 'BSNL',
            'state' => 'Tamil Nadu',
            'circle' => 'Chennai',
            'type' => 'Landline'
        ]),
        'created_at' => date('Y-m-d H:i:s', strtotime('-1 days'))
    ],
    [
        'user_id' => 83,
        'search_query' => '9234567890',
        'search_type' => 'Phone Number',
        'device_type' => 'iOS',
        'results_found' => 1,
        'cost' => 5.0,
        'status' => 'SUCCESS',
        'result_data' => json_encode([
            'phone' => '9234567890',
            'operator' => 'Idea',
            'state' => 'Gujarat',
            'circle' => 'Ahmedabad',
            'type' => 'Mobile'
        ]),
        'created_at' => date('Y-m-d H:i:s', strtotime('-12 hours'))
    ],
    [
        'user_id' => 83,
        'search_query' => '9876512345',
        'search_type' => 'Phone Number',
        'device_type' => 'Android',
        'results_found' => 1,
        'cost' => 5.0,
        'status' => 'SUCCESS',
        'result_data' => json_encode([
            'phone' => '9876512345',
            'operator' => 'Jio',
            'state' => 'Uttar Pradesh',
            'circle' => 'Lucknow',
            'type' => 'Mobile'
        ]),
        'created_at' => date('Y-m-d H:i:s', strtotime('-6 hours'))
    ],
    [
        'user_id' => 83,
        'search_query' => '8765409876',
        'search_type' => 'Phone Number',
        'device_type' => 'iOS',
        'results_found' => 1,
        'cost' => 5.0,
        'status' => 'SUCCESS',
        'result_data' => json_encode([
            'phone' => '8765409876',
            'operator' => 'Airtel',
            'state' => 'Telangana',
            'circle' => 'Hyderabad',
            'type' => 'Mobile'
        ]),
        'created_at' => date('Y-m-d H:i:s', strtotime('-2 hours'))
    ]
];

// Insert all searches
$inserted = 0;
foreach ($real_searches as $search) {
    try {
        $db->insert('user_searches', $search);
        $inserted++;
        echo "✅ Inserted: " . $search['search_query'] . " - " . $search['status'] . "<br>";
    } catch (Exception $e) {
        echo "❌ Error: " . $e->getMessage() . "<br>";
    }
}

echo "<hr>";
echo "<h2>✅ Summary</h2>";
echo "<p><strong>Total searches inserted: $inserted</strong></p>";
echo "<p style='color: green;'><strong>User #83 now has $inserted realistic phone search records!</strong></p>";

// Verify
$count = $db->fetch("SELECT COUNT(*) as cnt FROM user_searches WHERE user_id = 83");
echo "<p>Verification: user_searches table now has " . $count['cnt'] . " records for user #83</p>";

echo "<hr>";
echo "<h2>🔍 Preview of Data:</h2>";
$searches = $db->fetchAll("SELECT * FROM user_searches WHERE user_id = 83 ORDER BY created_at DESC");
echo "<table border='1' cellpadding='10' style='width: 100%;'>";
echo "<tr><th>Query</th><th>Type</th><th>Status</th><th>Device</th><th>Cost</th><th>Time</th></tr>";
foreach ($searches as $s) {
    echo "<tr>";
    echo "<td><strong>" . $s['search_query'] . "</strong></td>";
    echo "<td>" . $s['search_type'] . "</td>";
    echo "<td><strong style='color: " . ($s['status'] === 'SUCCESS' ? 'green' : 'red') . ";'>" . $s['status'] . "</strong></td>";
    echo "<td>" . $s['device_type'] . "</td>";
    echo "<td>₹" . $s['cost'] . "</td>";
    echo "<td>" . date('M d, g:i A', strtotime($s['created_at'])) . "</td>";
    echo "</tr>";
}
echo "</table>";

echo "<hr>";
echo "<p style='text-align: center;'>";
echo "<a href='admin/dashboard.php?page=search' style='background: #007aff; color: white; padding: 10px 20px; border-radius: 5px; text-decoration: none;'>✅ Go to Admin Search Page</a>";
echo "</p>";

?>
