<?php
/**
 * Add IP tracking columns to users table
 */

require_once 'config/config.php';
require_once 'classes/Database.php';

$db = Database::getInstance();

echo "🔄 Adding IP tracking columns to users table...\n";

try {
    // Check if columns already exist
    $check = $db->fetch("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS 
                         WHERE TABLE_NAME = 'users' 
                         AND COLUMN_NAME = 'last_device_ip'");
    
    if ($check) {
        echo "✅ Columns already exist!\n";
        exit;
    }
    
    // Add columns
    $db->query("ALTER TABLE users ADD COLUMN last_device_type VARCHAR(100) DEFAULT 'Unknown'");
    echo "✅ Added last_device_type column\n";
    
    $db->query("ALTER TABLE users ADD COLUMN last_device_ip VARCHAR(45) DEFAULT 'N/A'");
    echo "✅ Added last_device_ip column\n";
    
    $db->query("ALTER TABLE users ADD COLUMN last_login_at TIMESTAMP NULL");
    echo "✅ Added last_login_at column\n";
    
    echo "\n✨ Migration completed successfully!\n";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
}
?>
