<?php
/**
 * Email Verification Database Setup
 * Run this once to add email verification columns to users table
 */

require_once __DIR__ . '/config/config.php';
require_once __DIR__ . '/classes/Database.php';

$db = Database::getInstance();
$pdo = $db->getConnection();

try {
    // Check if columns exist
    $columns = $pdo->query("PRAGMA table_info(users)")->fetchAll(PDO::FETCH_ASSOC);
    $columnNames = array_column($columns, 'name');
    
    // Add email_verify_token column if it doesn't exist
    if (!in_array('email_verify_token', $columnNames)) {
        $pdo->exec("ALTER TABLE users ADD COLUMN email_verify_token VARCHAR(255) NULL DEFAULT NULL");
        echo "✅ Added email_verify_token column\n";
    } else {
        echo "✓ email_verify_token column already exists\n";
    }
    
    // Add email_verified_at column if it doesn't exist
    if (!in_array('email_verified_at', $columnNames)) {
        $pdo->exec("ALTER TABLE users ADD COLUMN email_verified_at DATETIME NULL DEFAULT NULL");
        echo "✅ Added email_verified_at column\n";
    } else {
        echo "✓ email_verified_at column already exists\n";
    }
    
    echo "\n✅ Database setup complete!\n";
    echo "📧 Email verification is now enabled.\n";
    echo "Users must verify their email before they can login.\n";
    
} catch (PDOException $e) {
    // Handle SQLite vs MySQL differences
    $errorCode = $e->getCode();
    
    if ($errorCode == '42S22' || strpos($e->getMessage(), 'already exists') !== false) {
        echo "✓ Columns already exist\n";
    } else if (strpos($e->getMessage(), 'Unknown column') === false && strpos($e->getMessage(), 'duplicate column') === false) {
        echo "ℹ️  Database already updated or different database system\n";
    } else {
        error_log("Error: " . $e->getMessage());
        echo "Note: Check error log for details\n";
    }
}
?>
