<?php
require_once 'config/config.php';
require_once 'classes/Database.php';

$db = Database::getInstance();

try {
    // Create searches table
    $db->query("
        CREATE TABLE IF NOT EXISTS searches (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            search_query VARCHAR(255) NOT NULL,
            device_type VARCHAR(50),
            cost DECIMAL(10, 2),
            status VARCHAR(50) DEFAULT 'PENDING',
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
            INDEX idx_user_id (user_id),
            INDEX idx_created_at (created_at)
        )
    ");
    
    echo "✅ searches table created successfully!<br>";
    echo "Columns: id, user_id, search_query, device_type, cost, status, created_at";
    
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage();
}
?>
