<?php
require_once 'config/database.php';

$db = Database::getInstance();

$users = $db->fetchAll("SELECT id, email, name, custom_code FROM users ORDER BY id ASC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Custom Codes</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        .container {
            background: white;
            border-radius: 12px;
            padding: 30px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
        }
        h1 {
            color: #333;
            margin-bottom: 30px;
            text-align: center;
        }
        .code-row {
            display: flex;
            align-items: center;
            padding: 12px;
            border-bottom: 1px solid #eee;
            background: #f9f9f9;
            margin-bottom: 8px;
            border-radius: 6px;
        }
        .code-row:hover {
            background: #f0f0f0;
        }
        .id-badge {
            background: #007bff;
            color: white;
            padding: 8px 12px;
            border-radius: 6px;
            font-weight: bold;
            min-width: 60px;
            text-align: center;
        }
        .custom-code {
            background: #28a745;
            color: white;
            padding: 8px 16px;
            border-radius: 6px;
            font-weight: bold;
            font-family: 'Courier New', monospace;
            margin: 0 15px;
            flex: 1;
        }
        .user-info {
            flex: 2;
            margin: 0 15px;
        }
        .user-name {
            font-weight: bold;
            color: #333;
        }
        .user-email {
            color: #666;
            font-size: 0.9em;
        }
        .copy-btn {
            background: #6c757d;
            color: white;
            border: none;
            padding: 8px 16px;
            border-radius: 6px;
            cursor: pointer;
            transition: 0.3s;
        }
        .copy-btn:hover {
            background: #5a6268;
        }
        .stats {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 30px;
            text-align: center;
        }
        .stat-number {
            font-size: 2em;
            font-weight: bold;
            color: #007bff;
        }
    </style>
</head>
<body>

<div class="container">
    <h1>🆔 User Custom Codes Management</h1>
    
    <div class="stats">
        <div class="stat-number"><?= count($users) ?></div>
        <p style="color: #666; margin: 0;">Total Users</p>
    </div>

    <div>
        <?php foreach ($users as $user): ?>
            <div class="code-row">
                <div class="id-badge">#<?= $user['id'] ?></div>
                <div class="custom-code"><?= htmlspecialchars($user['custom_code'] ?? 'N/A') ?></div>
                <div class="user-info">
                    <div class="user-name"><?= htmlspecialchars($user['name']) ?></div>
                    <div class="user-email"><?= htmlspecialchars($user['email']) ?></div>
                </div>
                <button class="copy-btn" onclick="copyToClipboard('<?= htmlspecialchars($user['custom_code'] ?? '') ?>')">
                    📋 Copy
                </button>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<script>
function showAlert(message) {
    const alertDiv = document.createElement('div');
    alertDiv.className = 'alert alert-success alert-dismissible fade show position-fixed top-0 start-50 translate-middle-x mt-3';
    alertDiv.style.zIndex = '9999';
    alertDiv.style.maxWidth = '500px';
    alertDiv.innerHTML = `${message}<button type="button" class="btn-close" data-bs-dismiss="alert"></button>`;
    document.body.appendChild(alertDiv);
    setTimeout(() => {
        alertDiv.remove();
    }, 4000);
}

function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(() => {
        showAlert('✅ Copied: ' + text);
    });
}
</script>

</body>
</html>
